#include <Servo.h>
Servo esc1;
int escPin1 = 3;
byte PWM_PIN = 5;
int Monitor = 0;
int minPulseRate        = 1000;
int maxPulseRate        = 2000;
unsigned long Timer1;
unsigned long TempoTrascorso;
int Start = 0;
int pwmAlto;
int Cnt1A;
int Cnt1B;
int Cnt2A;
int Cnt2B;

//SETUP
void setup() {
  Serial.begin(57600);
  esc1.attach(escPin1, minPulseRate, maxPulseRate);
  esc1.write(180);
  Serial.print("Pin PWM INPUT = ");
  Serial.println(PWM_PIN);
  Serial.println("Settare il motore tra 0(min) 90(half stick) 180(max)");
  LeggoMotore();
  delay (1000);
  Timer1 = millis() ;
}
//LOOP
void loop() {
  if (Serial.available() > 0) {
    // Read the new throttle value
    int throttle = NormalizzoMotore(Serial.parseInt());
    esc1.write(throttle);
    LeggoMotore();
  }
  pwmAlto = pulseIn(PWM_PIN, HIGH, 200000);
  TempoTrascorso = (millis() - Timer1) ;

  if (pwmAlto == 0 ) {
    //if (TempoTrascorso > 260) {
    if (TempoTrascorso > 255) {
      if (Start == 1) {
        Start = 2; //segnale dopo il segnale lungo
        Serial.println("***** ora si puo dare 90 (half Stik) *****") ;
      }
      if (TempoTrascorso > 4000 && Start == 0) {
        Start = 1; //segnale lungo iniziale
      }
      if (Start == 2) {
        Cnt1A = ( (int)(TempoTrascorso / 255));
        for  (int i = 0; i < Cnt1A; i++) {
          Serial.print("-") ;
        }
        Serial.print("- Timer = ") ;
        Serial.print(TempoTrascorso) ;
        Serial.print("       Cnt1A = ") ;
        Serial.println(Cnt1A) ;
      }
    }
    Cnt1A = 0;
    Cnt2A = 0;
    Cnt2B = 0;
    Timer1 = millis() ;
  }
  //delay(20);// 20 Millisec per ogni segnale
}
//END LOOP

int LeggoMotore() {
  int throttle = esc1.read();
  Serial.print("Il motore attualmente e' settato a: ");
  Serial.println(throttle);
  Serial.println("-----------------------------------------------------------------------------------");
  if (Start == 0) {
    Serial.println("*****  Collegare la batteria  ****");
  }
  if (throttle == 0) {
    Serial.println("  ATTENZIONE IL MOTORE E' ATTIVATO !!!! ");
  }
  Cnt1A = 0;
  Cnt2A = 0;
  Cnt2B = 0;
  Timer1 = millis() ;
  return throttle;
}
// mi assicuro che i valori immessi nella riga comando siano nell'intervallo 0 - 180
int NormalizzoMotore(int value) {
  if (value < 0) {
    return 0;
  } else if (value > 180) {
    return 180;
  }
  return value;
}
