#include <Servo.h>
Servo esc1;
int escPin1 = 3;
//Min and max pulse
int minPulseRate        = 1000;
int maxPulseRate        = 2000;

//SETUP
void setup() {
  Serial.begin(9600);
  Serial.setTimeout(500);
  esc1.attach(escPin1, minPulseRate, maxPulseRate);
  esc1.write(180);
  Serial.println("Istruzioni: fissare il motore ed eventualmente togliere l'elica");
  Serial.println("Collegare la batteria all'ESC SOLO DOPO AVER LANCIATO QUESTO PROGRAMMA !");
  Serial.println("A questo punto il motore emettera' i suoni che indicano che l'ESC e' in modalita' programmazione");
  Serial.println("1) Se l'ESC non era gia' stato calibrato per il motore in prova(o se volete cambiarne il punto di Brake)");
  Serial.println("potete inserire un numero da 0 a 40 per comunicare il punto di Brake quando udite i primi BEEP di accensione");
  Serial.println("Inserire 0 (zero) nella riga comando(e tasto INVIO) se volete il Brake nel punto 0 dello stick");
  Serial.println("oppure inserite un numero da 4 a 40 se volete spostare il punto di Brake sopra lo 0");
  Serial.println("A questo punto ATTENZIONE !! perche' ogni successivo valore introdotto andra' ad accendere il motore");
  Serial.println("2) attendete tanti BEEP sino a raggiungere il parametro che volete modificare");
  Serial.println("Dipende poi dal tipo di ESC(leggere il manuale dell'ESC) per modificare i vari parametri");
  Serial.println("Tenendo presente che dovrete inserire 90 per selezionare il parametro da modificare");
  Serial.println("e un 180 per confermare, ma anche questo dipende dal modello di ESC");
  Serial.println("Se il manuale parla di middle throttle inserite 90, mentre per full throttle inserite 180");
  Serial.println("Quando avrete finito la programmazione, staccate la batteria dall'ESC");
  Serial.println("Inviate uno 0 (zero) nella riga comando e date INVIO");
  Serial.println("per provare il motore riattaccare la batteria e a questo punto il motore partira' con valori al di sopra del Brake impostato");
  Serial.println("Settare il motore tra 0 - 180 nella riga comando seriale");
  readThrottle();
}
//LOOP
void loop() {
  if (Serial.available() > 0) {
    // Read the new throttle value
    int throttle = normalizeThrottle(Serial.parseInt());
    esc1.write(throttle);
    readThrottle();
  }
}
//END LOOP

//READ the throttle value   ************
int readThrottle() {
  int throttle = esc1.read();
  Serial.print("Il motore attualmente e' settato a: ");
  Serial.print(throttle);
  if (throttle == 0) {
    Serial.print("  ATTENZIONE IL MOTORE E' ATTIVATO !!!! ");
  }
  Serial.println();
  return throttle;
}
// mi assicuro che i valori immessi nella riga comando siano nell'intervallo 0 - 180
int normalizeThrottle(int value) {
  if (value < 0) {
    return 0;
  } else if (value > 180) {
    return 180;
  }
  return value;
}
