
-- ######################################################
-- ## Script by Ollicious,  bowdown@gmx.net            ##
-- ## Traduzione in italiano by BBC25185			   ##
-- ## V 1.0, 2015/09/15                                ##
-- ## Disegno dinamico, valori e funzioni iniziali,    ##
-- ## alcune dei widget e immagini BMP basate sul      ##
-- ## lavoro di Sockeye					               ##
-- ######################################################

-- #################### Definizioni #####################

------------------------------------------------------------
-- Definizioni dei Widget:                                --
-- La prima linea é commentata e fá la stessa cosa con le --
-- multiple linee presenti sotto                          --
-- Decidete in che formato prefetite visualizzarlo e modificate l'ARRAY -- 
-- in accordo a dove volete piazzato il WidGet   .        --
--                                                        --
-- Widgets nella versione V1.0                            --
-- Tensione: "battery", da mettere in una colonna da sola --
-- RSSI: "rssi", da mettere in una colonna da sola        --
-- Consumo: "capacity", da mettere in una colonna da sola --
-- Modo di volo: "fm"                                     --
-- STATO GPS: "gps"                                       --
-- Tempo: "timer"                                         --
-- Distanza: "dist"                                       --
-- Altezza: "height"                                      --
-- Velocitá: "speed"                                      --
-- Direione: "heading"                                    --
-- Punto HOME: "hp"                                       --
-- Registrazione dati: "logging"                          --
--                                                        --
-- Se vuoi aggiungere un proprio Widget, basta inserire una nuova funzione --
-- function callWidget(name, xCoord, yCoord).             --
--                                                        --
------------------------------------------------------------
-- ESEMPIO:
-- 2 colonne singole, 1 colonna con 3 righe, 1 colonna singola:
-- local widgetDefinition = {{"battery"},{"capacity"},{"dist", "height", "hp"},{"rssi"}}

-- 3 colonne a singola colonna:
-- local widgetDefinition = {{"battery"},{"capacity"},{"rssi"}}

-- 1 singola colonna con 3 righe:
-- local widgetDefinition = {{"fm", "gps","timer"}}

-- 1 singola colonna a singola riga:
-- local widgetDefinition = {{"battery"}}

local widgetDefinition = {{"battery"},{"fm", "gps","timer"},{"dist", "height", "speed"},{"hp","logging","heading"}}

-- local widgetDefinition = {}
-- widgetDefinition[1] = {"battery"}
-- widgetDefinition[2] = {"capacity"}
-- widgetDefinition[3] = {"rssi"}
-- widgetDefinition[4] = {"fm", "gps","timer"}
-- widgetDefinition[5] = {"dist", "height", "home"}

-- Modifica per settare la larghezza della singola colonna
local xOffsetSingle = 35 

-- Lasciare cosí come é
local displayWidth = 212
local displayHeight = 64
local xOffset
local xOffsetMulti
local numSingleCols
local numMultiCols

local myNumSat                                
local myQualSat                                 
local gpsCurrentLocation
local gpsId 
local gpsLatLon


-- ################### Funzioni ########################

---------------------
-- Arrottondamento --
---------------------
local function rnd(v,d)
	if d then
	 return math.floor((v*10^d)+0.5)/(10^d)
	else
	 return math.floor(v+0.5)
	end
end

--------------------------------
-- ID dei sensori telemetrici --
--------------------------------
local function getTelemetryId(name)
	field = getFieldInfo(name)
	if field then
	  return field.id
	else
	  return -1
	end
end
 
-------------------------------------
-- Recupero del valore telemetrico --
-------------------------------------
local function getValueOrDefault(value)
	local tmp = getValue(value)
	
	if tmp == nil then
		return 0
	end
	
	return tmp
end


-- #################### Widgets #########################

----------------------------------------------
-- Batteria;     Singola riga con il Widget --
----------------------------------------------
local function batteryWidget(xCoord, yCoord)

   local myCurrent = getValueOrDefault("VFAS")                             
   local myMaxV = 16.8                                        -- Massimo Voltaggio della batteria
   local myMinV = 14.0                                        -- Minimo Voltaggio della batteria
   local myRangeV = myMaxV - myMinV                           -- Formula di calcolo della tensione della batteria
   local myAvailV = myCurrent - myMinV                        -- Formula per il calcolo della differenza di batteria rimanente
   local myPercent = math.floor(myAvailV / myRangeV * 100)    -- Formula per il calcolo della percentuale
   
   if myAvailV < 0 then myAvailV = 0 end                      -- Controllo del valore per fuori range
   if myPercent < 0 then myPercent = 0 end                    -- Controllo del valore per fuori range
   if myPercent > 100 then myPercent = 100 end                -- Controllo del valore per fuori range
   
   local myPxHeight = math.floor(myPercent * 0.37)            -- Calcolo della lunghezza della barra della batteria
   local myPxY = 11 + 37 - myPxHeight

   lcd.drawPixmap(xCoord + 10, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/batteryh.bmp")           -- Immagine della batteria da inserire

	 if myPercent > 0 then
    	lcd.drawFilledRectangle(xCoord + 13, myPxY, xCoord + 19, myPxHeight, FILL_WHITE ) 
   end


   local i = 36
   while (i > 0) do
    	lcd.drawLine(xCoord + 14, yCoord + 10 + i, xCoord + 20, yCoord + 10 + i, SOLID, GREY_DEFAULT)
    	i= i-2
   end

   if (myCurrent > myMaxV) or (myCurrent < myMinV) then
		lcd.drawNumber(xCoord + 1,yCoord + 55, myCurrent ,PREC1 + LEFT + BLINK+ SMLSIZE)
   else
		lcd.drawNumber(xCoord + 1,yCoord + 55, myCurrent ,PREC1 + LEFT + SMLSIZE)
   end
   lcd.drawText(lcd.getLastPos(), yCoord + 55, "v", SMLSIZE)

end

------------------------------------------ 
-- RSSI;        Singola riga col Widget --
------------------------------------------
local function rssiWidget(xCoord,yCoord)

  local percent = 0
  
  if getValueOrDefault("RSSI") > 38 then
   percent = ((math.log(getValueOrDefault(200)-28, 10)-1)/(math.log(72, 10)-1))*100
  else
   percent = 0
  end

  if percent > 90 then
   	lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh10.bmp")
  elseif percent > 80 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh09.bmp")
  elseif percent > 70 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh08.bmp")
  elseif percent > 60 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh07.bmp")
  elseif percent > 50 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh06.bmp")
	elseif percent > 40 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh05.bmp")
  elseif percent > 30 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh04.bmp")
  elseif percent > 20 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh03.bmp")
  elseif percent > 10 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh02.bmp")
  elseif percent > 0 then
		lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh01.bmp")
  else
    lcd.drawPixmap(xCoord + 4, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/RSSIh00.bmp")
  end

  lcd.drawChannel(xCoord + 6, yCoord + 55, 200, LEFT + SMLSIZE)
  lcd.drawText(lcd.getLastPos(), yCoord + 55, "dB", SMLSIZE)
  
end  

------------------------------------------
-- Capacitá;    Singola riga col Widget --
------------------------------------------
local function capacityWidget(xCoord,yCoord)

   local myCurrent = getValueOrDefault("VFAS")                             
   local myMaxV = 16.8                                        -- Massimo Voltaggio della batteria
   local myMinV = 14.0                                        -- Minimo Voltaggio della batteria
   local myRangeV = myMaxV - myMinV                           -- Formula di calcolo della tensione della batteria
   local myAvailV = myCurrent - myMinV                        -- Formula per il calcolo della differenza di batteria rimanente
   local myPercent = math.floor(myAvailV / myRangeV * 100)    -- Formula per il calcolo della percentuale
   
   if myAvailV < 0 then myAvailV = 0 end                      -- Controllo del valore per fuori range
   if myPercent < 0 then myPercent = 0 end                    -- Controllo del valore per fuori range
   if myPercent > 100 then myPercent = 100 end                -- Controllo del valore per fuori range
   
   local myPxHeight = math.floor(myPercent * 0.37)            -- Calcolo della lunghezza della barra della batteria
   local myPxY = 11 + 37 - myPxHeight

   lcd.drawPixmap(xCoord + 10, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/batteryh.bmp")           -- Immagine della batteria da inserire

	 if myPercent > 0 then
    	lcd.drawFilledRectangle(xCoord + 13, myPxY, xCoord + 19, myPxHeight, FILL_WHITE ) 
   end


   local i = 36
   while (i > 0) do
    	lcd.drawLine(xCoord + 14, yCoord + 10 + i, xCoord + 20, yCoord + 10 + i, SOLID, GREY_DEFAULT)
    	i= i-2
   end

   if (myCurrent > myMaxV) or (myCurrent < myMinV) then
		lcd.drawNumber(xCoord + 1,yCoord + 55, myCurrent ,LEFT + BLINK+ SMLSIZE)
   else
		lcd.drawNumber(xCoord + 1,yCoord + 55, myCurrent ,LEFT + SMLSIZE)
   end
   lcd.drawText(lcd.getLastPos(), yCoord + 55, "mAh", SMLSIZE)

end

----------------------------------------------
-- DISTANZA;       Multipla riga col Widget --
----------------------------------------------
local function distWidget(xCoord, yCoord)

   local dist = getValueOrDefault("Dist")
   
   if simModeOn == 1 then
      dist = tdist
   end
   
   lcd.drawPixmap(xCoord + 1, yCoord + 2, "/SCRIPTS/TELEMETRY/OLIMETRY/dist.bmp")
   lcd.drawNumber(xCoord + 18, yCoord + 7, dist, LEFT)
   lcd.drawText(lcd.getLastPos(), yCoord+ 7, "m", 0)
   
end
   
-----------------------------------------------
--  Altezza;        Multipla riga Col Widget --
-----------------------------------------------
local function heightWidget(xCoord, yCoord)

   local height = getValueOrDefault("GAlt")
   
   if simModeOn == 1 then
      height = theight
   end
   
   lcd.drawPixmap(xCoord + 1, yCoord + 2, "/SCRIPTS/TELEMETRY/OLIMETRY/hgt.bmp")
   lcd.drawNumber(xCoord + 18, yCoord + 7, height, LEFT)                -- 213 Height
   lcd.drawText(lcd.getLastPos(), yCoord + 7, "m", 0)
end

------------------------------------------------
--  Velocitá;        Multipla riga Col Widget --
------------------------------------------------
local function speedWidget(xCoord, yCoord)

   local speed = getValueOrDefault("GSpd")
   
   lcd.drawPixmap(xCoord + 1, yCoord + 2, "/SCRIPTS/TELEMETRY/OLIMETRY/speed.bmp")
   lcd.drawNumber(xCoord + 18, yCoord + 7, speed * 3.6, LEFT)
   lcd.drawText(lcd.getLastPos(), yCoord + 7, "kmh", 0)
end

------------------------------------------------
--  Direzione;       Multipla riga Col Widget --
------------------------------------------------
local function headingWidget(xCoord, yCoord)

   local heading = getValueOrDefault("Hdg") 
   
   lcd.drawPixmap(xCoord + 1, yCoord + 2, "/SCRIPTS/TELEMETRY/OLIMETRY/compass.bmp")
   lcd.drawNumber(xCoord + 18, yCoord + 7, heading, LEFT)
   lcd.drawText(lcd.getLastPos(), yCoord + 7, "dg", 0)
end

----------------------------------------------------------
--  Registrazione dati;        Multipla riga col Widget --
----------------------------------------------------------
local function loggingWidget(xCoord, yCoord)

    if getValueOrDefault(92) < 0 then                                         -- Da modificare per farlo corrispondere allo switch usato
      lcd.drawText(xCoord + 16, yCoord+ 3,"ON", MIDSIZE)
      lcd.drawPixmap(xCoord + 2, yCoord+ 5, "/SCRIPTS/TELEMETRY/OLIMETRY/save.bmp")
   else
      lcd.drawText(xCoord + 16,yCoord+ 3,"OFF", MIDSIZE)
      lcd.drawPixmap(xCoord + 2, yCoord+ 5, "/SCRIPTS/TELEMETRY/OLIMETRY/saveoff.bmp")

   end
end

----------------------------------------------
-- Modi di volo;   Multipla riga Col Widget --
----------------------------------------------
local function fmWidget(xCoord, yCoord)

  lcd.drawPixmap(xCoord + 1, yCoord + 2, "/SCRIPTS/TELEMETRY/OLIMETRY/fm.bmp")            -- Immagine che carica per il modo di volo
  
  if getValueOrDefault("RSSI") > 20 then                                -- Recupera il valore di RSSI e se maggiore di 20:
     --if getValueOrDefault(97) > 0 then                                -- é in modalitá RETURN TO HOME? (Switch F)
        --lcd.drawText(66, 5, "RTH", BLINK+MIDSIZE)                     -- Visualizza la scritta RTH in modo lampeggiante
     --else                                                             -- altrimenti
        if getValueOrDefault(98) < 0 then                               -- Controlla lo switch della funzione IOC (Switch G)
           if getValueOrDefault(96) > 0 then                            -- Modalitá MANUALE (Switch E)
              lcd.drawText(xCoord + 1, yCoord + 7, "Man", 0)                       -- Visualizza la scritta MAN
           else                                                       
              if getValueOrDefault(96) == 0 then                        -- Modalitá ATTI (Switch E)
                 lcd.drawText(xCoord + 18, yCoord + 7, "Atti", 0)                   -- ATTI Attivo
              else                                                    
                 lcd.drawText(xCoord + 18, yCoord + 7, "GPS", 0)                    -- GPS Attivo
              end                                                      
           end
        else                                                            -- Modalitá IOC attiva
           if getValueOrDefault(98) == 0 then                           -- é in modalitá CL? (Switch G)
              lcd.drawText(xCoord + 18, yCoord + 7, "CL", 0)                        -- Scrivi CL
           else                                                         -- é in modalitá HL? (Switch G)
              lcd.drawText(xCoord + 18, yCoord + 7, "HL", 0)                        -- Scrivi HL
           end                                                        
       end                                                            
     --end                                                             
  else                                                                  -- l'RSSI é inferiore al valore 20
    lcd.drawText(xCoord + 18, yCoord + 7, "FAIL", BLINK+0)                          -- Scrivi FAIL
  end   

end

----------------------------------------------
-- Tempo;          Multipla riga Col Widget --
----------------------------------------------
local function timerWidget(xCoord, yCoord)

  lcd.drawPixmap(xCoord + 1, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/timer_1.bmp")
  lcd.drawTimer(xCoord + 18, yCoord + 8, getValueOrDefault(196), 0) 
  
 end
 
 -----------------------------------------
 -- GPS;           MULTI Row Col Widget --
 -----------------------------------------
 local function gpsWidget(xCoord,yCoord)
 
    if simModeOn == 1 then
	  myNumSat = tmyNumSat
      myQualSat = tmyQualSat  
    end

   
	if myQualSat == 0 then
		lcd.drawPixmap(xCoord + 1, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/sat0.bmp")                -- Nessun FIX
	elseif myQualSat == 2 then
		lcd.drawPixmap(xCoord + 1, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/sat1.bmp")                -- 2D Fix
	elseif myQualSat == 3 then
		lcd.drawPixmap(xCoord + 1, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/sat2.bmp")                -- 3D Fix
	elseif myQualSat == 4 then
		lcd.drawPixmap(xCoord + 1, yCoord + 1, "/SCRIPTS/TELEMETRY/OLIMETRY/sat3.bmp")                -- GPS differenziale (DGPS)
	end				
	 
	 
	if myNumSat > 5 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_6.bmp")               -- 6 o piú satelliti
	elseif myNumSat > 4 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_5.bmp")               -- 5 Satelliti 
	elseif myNumSat > 3 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_4.bmp")               -- 4 Satelliti
	elseif myNumSat > 2 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_3.bmp")               -- 3 Satelliti
	elseif myNumSat > 1 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_2.bmp")               -- 2 Satelliti
	elseif myNumSat > 0 then
		lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_1.bmp")               -- 1 Satellite
	else
	lcd.drawPixmap(xCoord + 13, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/gps_0.bmp")                 -- Nessun satellite
	end
	 
	 
   lcd.drawNumber(xCoord + 19, yCoord + 1, myNumSat,  SMLSIZE)                        -- Numero dei satelliti presi
 end

 -----------------------------------------
 -- Punto HOME;    Multipla riga Col Widget --
 -----------------------------------------
 local function hpWidget(xCoord, yCoord)
   if gpsCurrentLocation == "not currently available" then
      lcd.drawPixmap(xCoord + 1, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/home1.bmp")
      lcd.drawText(xCoord + 19, yCoord + 5, "?", MIDSIZE + BLINK)
   elseif myNumSat > 5 then
      lcd.drawPixmap(xCoord + 1, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/home.bmp")
      lcd.drawPixmap(xCoord + 19, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/check.bmp")
   else
      lcd.drawPixmap(xCoord + 1, yCoord + 3, "/SCRIPTS/TELEMETRY/OLIMETRY/home.bmp")
      lcd.drawText(xCoord + 19, yCoord + 5, "X",  BLINK+ MIDSIZE)
   end
 end
 
-- ######################################################
 
----------------------------------
-- Chiamate definite dei Widget --
----------------------------------
local function callWidget(name, xPos, yPos)
	if (xPos ~= nil and yPos ~= nil) then
		if (name == "battery") then
			batteryWidget(xPos, yPos)
		elseif (name == "dist") then
			distWidget(xPos, yPos)
		elseif (name == "height") then
			heightWidget(xPos, yPos)
		elseif (name == "fm") then
			fmWidget(xPos, yPos)
		elseif (name == "timer") then
			timerWidget(xPos, yPos)
		elseif (name == "gps") then
			gpsWidget(xPos, yPos)
		elseif (name == "rssi") then
			rssiWidget(xPos, yPos)
		elseif (name == "capacity") then
			capacityWidget(xPos, yPos)
		elseif (name == "hp") then
			hpWidget(xPos, yPos)
		elseif (name == "speed") then
			speedWidget(xPos, yPos)
		elseif (name == "logging") then
			loggingWidget(xPos, yPos)
		elseif (name == "heading") then
			headingWidget(xPos, yPos)
		else
			return
		end
	end
end

------------------------------------
--   Costruzione della griglia    --
------------------------------------
local function buildGrid(def)

	local tempSumX = -1
	local tempSumY = -1
	
	-- ## Colonne
	for i=1, # def, 1
	do
		-- crea una singola colonna vicina
		if (# def[i] == 1) then
			xOffset = xOffsetSingle
		else
			xOffset = xOffsetMulti
		end
		
		-- Linee verticali
		lcd.drawLine(tempSumX, -1, tempSumX, displayHeight, SOLID, GREY_DEFAULT)

		-- ## Righe
		for j=1, # def[i], 1
		do
			-- Linee orizzontali
			lcd.drawLine(tempSumX, tempSumY, tempSumX + xOffset, tempSumY, SOLID, GREY_DEFAULT)
			
			-- Widget
			callWidget(def[i][j], tempSumX + 1, tempSumY + 1)
			
			tempSumY = tempSumY + math.floor(displayHeight / # def[i])
		end
		
		-- Reinizializza valori
		tempSumY = -1
		tempSumX = tempSumX + xOffset
	end
end

-- ################### Sfondo #######################
local function background()

end

-- ###################### Inizializzazzione ##########################
local function init()

	-- Calcolo di xOffset dipendente da quante singole colonne vengono usate dai widget
	numSingleCols = 0
	numMultiCols = 0
	for i=1, # widgetDefinition, 1
	do
		if (# widgetDefinition[i] == 1) then
			numSingleCols = numSingleCols + 1
		else
			numMultiCols = numMultiCols + 1
		end
	end
	xOffsetMulti = (displayWidth - (numSingleCols * xOffsetSingle)) / numMultiCols
	
	-- Punto Casa
	myNumSat =  getValueOrDefault("Sats")                                   
    myQualSat =  getValueOrDefault("Fix")                                  
   
	
	gpsId = getTelemetryId("GPS") 
	gpsLatLon = getValue(gpsId)
	if (type(gpsLatLon) ~= "table") then
		gpsCurrentLocation = "not currently available"
	end
	
end

-- ####################### Run #########################
local function run(event)
	
	-- Cancella lo schermo
	lcd.clear()	
	
	-- Creazione griglia
	buildGrid(widgetDefinition)
end

return{init=init,run=run,background=background}