function GetSensorValue (name)
	fieldinfo = getFieldInfo(name)
	if fieldinfo then
		SensorId = fieldinfo['id']
		Value = getValue(SensorId)
		return Value
	else
		return 0
	end
end


local function run(event)


	local settings = getGeneralSettings()
-- ################# Draw Frames ########################
  lcd.clear()
  lcd.drawLine(37, -1, 37, 64, SOLID, GREY_DEFAULT)    -- Vertical 1
  lcd.drawLine(100, 21, 100, 42, SOLID, GREY_DEFAULT)  -- Vertical 2
  lcd.drawLine(162, -1, 162, 64, SOLID, GREY_DEFAULT)  -- Vertical 3

  lcd.drawLine(36, 21, 162, 21, SOLID, GREY_DEFAULT)   -- Horizontal 1
  lcd.drawLine(36, 42, 162, 42, SOLID, GREY_DEFAULT)   -- Horizontal 2


-- ################ CleanFlight Battery Display ###############
	local myVoltage = 0;
	myVoltage = GetSensorValue('Vfas') + 0.2				  --Prende il valore di tensione
                                
   local myMaxV = 12.40                                       -- Massima tensione del pacco LiPo (4S)
   local myMinV = 9.00                                        -- Minima tensione del pacco LiPo (4S)
   local myRangeV = myMaxV - myMinV                           -- Range
   local myAvailV = myVoltage - myMinV                        -- Disponibilita rimanente
   local myPercent = math.floor(myAvailV / myRangeV * 100)    -- Conto percentuale
   
   if myAvailV < 0 then myAvailV = 0 end                      -- 
   if myPercent < 0 then myPercent = 0 end                    -- 
   if myPercent > 100 then myPercent = 100 end                -- 
   
   local myPxHeight = math.floor(myPercent * 0.37)            -- Calcolo della barra
   local myPxY = 11 + 37 - myPxHeight

   lcd.drawPixmap(3, 1, "/SCRIPTS/BMP/battery.bmp")           -- Stampo della immagine

	 if myPercent > 0 then								      -- Stampo della barra
    	lcd.drawFilledRectangle(8, myPxY, 21, myPxHeight, FILL_WHITE ) 
   end


   local i = 36
   while (i > 0) do
    	lcd.drawLine(7, 11 + i, 27, 11 +i, SOLID, GREY_DEFAULT)
    	i= i-2
   end

   if (myVoltage > myMaxV) or (myVoltage < myMinV) then
   		lcd.drawNumber(4,55, myVoltage ,PREC2 + LEFT + BLINK)
   else
  		lcd.drawNumber(4,55, myVoltage ,PREC2 + LEFT)
   end
   lcd.drawText(lcd.getLastPos(), 55, "v", 0)

-- ################### Cleanflight Current Show  #######################
	local myCurrent = 0
	myCurrent = GetSensorValue ('Curr')
	if (myCurrent > 0)
		lcd.drawNumber(63,26, myCurrent * 100  ,MIDSIZE + PREC2 + LEFT)		--Visualizzazzione della corrente
		lcd.drawText(lcd.getLastPos(), 26, "a", MIDSIZE)
	else
		lcd.drawText(43,26, "ID ERR", MIDSIZE)
	end
  
-- ################### Modi di VOLO ###############################


lcd.drawPixmap(43, 3, "/SCRIPTS/BMP/fm.bmp")         
local RSSIValue = 0
RSSIValue = GetSensorValue ('RSSI')
if (RSSIValue > 20) then											-- Lettura valore RSSI
	if getValue(93) < 0 then										-- Lettura swith B (ID 93)
		lcd.drawText(63, 5, "ANGLE", MIDSIZE)						-- Angle mode
		if getValue(94) < 0 then
			lcd.drawText(lcd.getLastPos(), 9, " ", 0)						-- Nothing
		elseif getValue(94) == 0 then
			lcd.drawText(lcd.getLastPos(), 9, "+BARO", 0)					-- Baro mode
		else
			lcd.drawText(lcd.getLastPos(), 9, "+BARO+MAG", 0)				-- Baro + MAG mode
		end
	elseif getValue(93) == 0 then											-- Lettura swith B (ID 93)
		lcd.drawText(63, 5, "HORIZ", MIDSIZE)								-- Horizon mode
		if getValue(94) < 0 then
			lcd.drawText(lcd.getLastPos(), 9, " ", 0)						-- Nothing
		elseif getValue(94) == 0 then
			lcd.drawText(lcd.getLastPos(), 9, "+BARO", 0)					-- Baro mode
		else
			lcd.drawText(lcd.getLastPos(), 9, "+BARO+MAG", 0)				-- Baro + MAG mode
		end
	else
		lcd.drawText(63, 5, "ACRO", MIDSIZE)								-- Horizon mode
		if getValue(94) < 0 then
			lcd.drawText(lcd.getLastPos(), 9, " ", 0)						-- Nothing
		elseif getValue(94) == 0 then
			lcd.drawText(lcd.getLastPos(), 9, "+BARO", 0)					-- Baro mode
		else
			lcd.drawText(lcd.getLastPos(), 9, "+BARO+MAG", 0)				-- Baro + MAG mode
		end
	end
else                                                               
    lcd.drawText(66, 5, "FAIL", BLINK+MIDSIZE)                   
end                                                                 


-- ####################### Adjust  ##################################

if getValue(92) < 0 then
	lcd.drawText(103, 26, "Rc RATE", MIDSIZE)
elseif getValue(92) == 0 then
	lcd.drawText(103, 26, "I ADJST", MIDSIZE)
else
	lcd.drawText(103, 26, "P ADJST", MIDSIZE)
end


-- ####################### Timer Anzeige  ##########################

  lcd.drawPixmap(46, 46, "/SCRIPTS/BMP/timer.bmp")
  lcd.drawTimer(77, 46, getValue(196) * -1, DBLSIZE)                  -- Timer 1 value [seconds]

-- ####################### Logging display ############################
-- ###  Logging auf logischem Schalter LS1 = source 100   #############

   if getValue(100) > 0 then									--Lettura Switch Logico L1 (ID 100)
   lcd.drawText(154,49,"O", SMLSIZE + BLINK)
   lcd.drawPixmap(151, 51, "/SCRIPTS/BMP/save.bmp")
   end
-- ############### RSSI ##############################################
	
	if (RSSIValue > 20) then											-- Lettura valore RSSI
		percent = ((math.log(RSSIValue-28, 10)-1)/(math.log(72, 10)-1))*100
  else
   percent = 0
  end

	if percent > 90 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI10.bmp")
	elseif percent > 80 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI09.bmp")
	elseif percent > 70 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI08.bmp")
	elseif percent > 60 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI07.bmp")
	elseif percent > 50 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI06.bmp")
	elseif percent > 40 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI05.bmp")
	elseif percent > 30 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI04.bmp")
	elseif percent > 20 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI03.bmp")
	elseif percent > 10 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI02.bmp")
	elseif percent > 0 then
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI01.bmp")
	else
		lcd.drawPixmap(164, 1, "/SCRIPTS/BMP/RSSI00.bmp")
	end
  
	IF (RSSIValue > 0) then
		lcd.drawNumber(178,55, RSSIValue, LEFT)
		
	else
		lcd.drawText (178, 55, "RX Err", 0)

end

return { run=run }