; scan2dat
; (C) Copyright 2003, by Louis Dionne, 2003/01/19 [dionnel666@hotmail.com]


; Cet utilitaire crit en AutoLisp 
; permet la cration d'un fichier .dat bass sur des dessins AutoCAD.
; Il peut convertir des Spline, Pline ou Line et 
; distribue galement les points du dat le long de chaque Pline ou Spline.
; 
; Pour charger, utilisez APPLOAD est pointez sur le fichier scan2dat.lsp
; Puis pour invoquer, tapez la commande SCAN2DAT.
;
; Pour une reprsentation plus fidle, demandez un plus grand nombre de points.
; 
; Slectionner des Spline, Pline et Line qui bout  bout complteront une forme ferme.
; Chaque segment droit devrait tre un Line/Pline spar pour pouvoir avoir des points  leur extrmits
; Les points sont disposs  distance gale le long de chaque lment.
;
; L'utilitaire devrait fonctionner sans problme sur les versions R14 jusqu' la version courante.
; En fait, je pense que ca devrait marcher avec une aussi vieille version que R9.
;
; La Layer active doit tre ON.
; Des entits temporaires sont cres puis effaces.
;
; L'utilitaire supporte prsentement le franais et l'anglais pour l'interaction usager.
; Les langues additionnelles sont facile  ajouter.
; Pour les monolinguistes, la premire question pose est la langue voulue.
;
; Todo list
;
; Historique
; 2003/01/09
; - Version initiale 
; 2003/01/16
; - Ajout du support des LINE
; - Tous les strings sont traduits
;
; Cet utilitaire est fourni sans aucune garantie que ce soit.
; Toute poursuite judiciaire aura pour rponse la visite de l'escouade des Taekwon-dodo.
;
; Louis Dionne
; somewhere in frozen Canada
; [dionnel666@hotmail.com]



; Helper function doing most of the work
(defun f_coord ( / fp div doreverse beacon x_ent elast ewalk px py coord)

	; Select the Spline or Pline
	(setq OK nil)
	(while (not OK) 
		(setq enttype (cdr (assoc 0 (entget (setq x_ent (car (entsel st10)))))))
		(if (= enttype "LWPOLYLINE") (setq OK 1))
		(if (= enttype "SPLINE") (setq OK 1))
		(if (= enttype "POLYLINE") (setq OK 1))
		(if (= enttype "LINE") (setq OK 2))
	)

	(if (= OK 1)
		; Check if the Spline/PLine is closed
		; if closed Divide will produce an additional point at the beginning.
		(if (= 1 (boole 1 1 (cdr (assoc 70 (entget x_ent)))) )
			(progn (setq Closed T)   (princ st12))
			(progn (setq Closed nil) (princ st13))
		)
		; The LINE is always Open
		(progn (setq Closed nil) (princ st13))	
	)


	; Highlight Curve
	; Highlight/Indicate start/direction of points

	; Ask how many points ? min 2.
	(initget 6)
	(setq div (getint  st06))
	(if (not div) (setq div 100))
	(princ st06a)(prin1 div)


	; Generate pts
	; Save pts


	; Get the start of the Spline/PLine/Line
	(setq firstp (assoc 10 (entget x_ent)))
	(if (= OK 1)
		; For Spline and Pline
		(setq lastp  (assoc 10 (reverse (entget x_ent))))
		; For LINE
		(setq lastp  (assoc 11 (reverse (entget x_ent))))
	)

	(if Closed
		(progn
			(setq elist nil pos 0 max_pos 0)
		)
		(progn
			(setq elist (list firstp))
			(setq max_x (cadr firstp) min_x (cadr firstp) start_y (caddr firstp))
			(setq pos 1 max_pos 0)
			(setq px (cadr firstp))
			(setq py (caddr firstp))
			; Display the entity name and coordinates
			(dprinc "\n")(dprinc "Firstp: ")
			(dprin1 px)(dprinc "\t ")(dprin1 py)
		)
	)

        ; Put a beacon entity.
	(setvar "PDMODE" pmode_1st)
	(command "_point" (cdr firstp))
	(setq beacon (entlast))
	(setvar "PDMODE" pmode_std)

	; Divide the Spline to get Points
	(command "_divide" x_ent div)

	(if (not Closed)
		(progn
		(setvar "PDMODE" pmode_last)
		(command "_point" (cdr lastp))
		)
	)


	; Reverse ?
	(initget 0 st02) 
	(setq  doreverse (getkword st03b))
	(if (not doreverse) (setq doreverse st04)) 
	(princ st3c)(princ doreverse)


	; At this point, 
	; all entities between the last entity and the beacon entity should be points 
	; and will be picked up.
	; This is the perfect spot to edit/change the points before moving on.
	; ==============>>> Control Points (100) Next\Move\Exit:

	; Get the list of Points using the beacon entity
	; elast is the last divide point
	(setq elast (entlast))
	; ewalk points the first divide point
	(setq ewalk (entnext beacon)) 
	; Create a selection set with the beacon entity and the first Point
	(setq sel (ssadd beacon))


	; Go through all Points created by the Divide command
	(while (and (/= ewalk nil) (/= ewalk elast))
		; Record each Points that were created
		(ssadd ewalk sel)
		; Get the coordinates for each Points
		(setq coord (assoc 10 (entget ewalk)))
		(setq px (cadr coord))
		(setq py (caddr coord))

		; Add the coordinates of this point to the list
		(setq elist (append elist (list coord)))

		; Display the entity name and coordinates
		(dprinc "\n")(dprin1 ewalk)(dprinc "pos : ")(dprin1 pos)(dprinc "\t :")
		(dprin1 px)(dprinc "\t ")(dprin1 py)

		; step to next Point
		(setq pos (1+ pos))
		(setq ewalk (entnext ewalk))
	)

	; We now have the list of all points in the form of (10 px py pz) in elist

	; Flip the list if Reverse was requested
	(dprinc "\nAvant   = ")(dprin1 elist)
	(if (/= doreverse st04) (setq elist (reverse elist)))
	(dprinc "\n\nApres rotation = ")(dprin1 elist)


	; Erase all the Points that were created
	(if (= st04 ShowMarker)
		(command "_erase" sel ""); erase all those extra entite created
	)



)


; Helper function doing the normalization and spitting the coordonates to the file
(defun f_norm (fp tlist)

	; Go through all Points created by the Divide command
	(setq pos 0 min_x nil max_x nil start_y nil max_pos 0)
	(foreach coord tlist	
		(setq px (cadr coord))
		(setq py (caddr coord))

		; remember the Min and Max and the Starting Y at Max X.
		(if (not min_x)  
			(setq min_x px max_x px start_y py max_pos pos)
		)
		
		(if (< px min_x) (setq min_x px))
		(if (> px max_x) (setq max_x px start_y py max_pos pos))

		; Display the entity name and coordinates
		(dprinc "\n")(dprinc "pos : ")(dprin1 pos)(dprinc "\t :")
		(dprin1 px)(dprinc "\t ")(dprin1 py)

		; step to next Point
		(setq pos (1+ pos))
	)


	; Display the min and max
	(dprinc "\nMin     = ")(dprin1 min_x)
	(dprinc "\nMax     = ")(dprin1 max_x)
	(dprinc "\nStart y = ")(dprin1 start_y)
	(dprinc "\nMax_pos = ")(dprin1 max_pos)
	(dprinc "\nAvant   = ")(dprin1 tlist)


	(dprinc "\n\nAvant rotation = ")(dprin1 tlist)
	(dprinc "\n\n")

	; Do a rotation of the list to get the max_x first
	(setq pos 0)
	(while (/= pos max_pos)
		(setq tlist (append (cdr tlist) (list (car tlist))))
		(setq pos (1+ pos))
	)
	(dprinc "\n\nApres rotation = ")(dprin1 tlist)
	(dprinc "\n\n")

	; Repeat the first entry at the end
	(setq tlist (append tlist (list (car tlist))))

	(dprinc "\n\nApres ajout    = ")(dprin1 tlist)
	(dprinc "\n\n")


	; Go through the list now
	(setq pos 0)
	(foreach coord tlist	
		(setq pos (1+ pos))

		(setq px (cadr coord))
		(setq py (caddr coord))
		; Display the coordinates
		(princ "\n")(prin1 px)(princ "\t ")(prin1 py)

		(if (/= donormalize st04)
			(progn
			; do the transformation/normalization
			; to get the curve between 0-1 on the X axis
			; translate X
			(setq px (- px min_x))
			; Need to move Y to put 1st point at y=0
			(setq py (- py start_y))
			; scale X and Y
			(setq px (/ px (- max_x min_x)))
			(setq py (/ py (- max_x min_x)))

			(princ st25)(princ (rtos px))(princ "\t ")(princ (rtos py))

			)
		)

		; Print the coordinates in the file
		(princ "\n" fp)(princ (rtos px) fp)(princ "\t " fp )(princ (rtos py) fp)
	)
	; Print the count of points
	(princ st11)(prin1 pos)

)


; Function to produce a DAT file as the basis for a CNC foamcutting project.
(defun C:scan2dat (/ ext fname dospline donormalize doreverse fp div Closed)

	(setq 
	ld_version	"scan2dat v1.03"
	ld_copyright	"(C) Copyright 2003, Louis Dionne, 2003/01/19 [dionnel666@hotmail.com]"

	Debug		nil
	pmode_1st	32
	pmode_last	67
	pmode_std	3
	)

	
	(if Debug
		(setq 
			dprinc	princ
			dprin1	prin1
		)
		(setq 
			dprinc	null
			dprin1	null
		)
	)

	(setvar "OSMODE" 0)
	(setvar "CMDECHO" 0)
	(setvar "PDMODE" pmode_std)

	(setq old_lunits (getvar "LUNITS"))
	(setvar "LUNITS" 2)
	(setq old_luprec (getvar "LUPREC"))
	(setvar "LUPREC" 8)

	; Define some constants
	(setq   ext ".dat")

	; Select Language
	(initget 0 "English Franais") 
	(setq  lang (getkword "\nEnter language of choice (E/F) <E>: "))
	(if (not lang ) (setq lang "English"))

	; String bank
	(if (= lang "English")
		; English
		(setq
		st00    "\nLanguage is: "
		st00a	"\nProducing a DAT file as the basis for a CNC foam-cutting project."
		st01	"\nEnter destination file name (no extension): "
		st02	"Yes No"
		st03	"\nDo you want to normalize (scaled in 0.0-1.0) ? (Y/N) <Y>: "
		st03a	"\n - Normalisation: "
		st03b   "\nDo you want to reverse the direction of the curve? (Y/N) <N>: "
		st03c	"\n - Reverse  : "
		st04    "No"
		st04a   "Yes"
		st05	"\nEnter comment for the first line in the .dat file: "
		st06	"\nEnter the number of coordinates you want <100>: "
		st06a	"\n - Number of points: "
		st07	"\n\nFile "
		st08	" saved."
		st09	"\n- End -"
		st10	"\nSelect the Line/Spline/Pline to write to file: "
		st11	"\nQuantity of points generated: "
		st12	"\n - Entity is CLOSED."
		st13	"\n - Entity is OPEN."
		st14	"\nDo you want to show markers ? (Y/N) <N>: "
		st14a	"\n - Marker   : "
		st20	"Add"
		st21	"eXit"
		st22	"Add eXit"
		st23	"\nAdd\\eXit <X>:"
		st24	"\n - Selection: "
		st25	"\t Normalized: "

		ut00	"\n\nThis tool will write a DAT file from connected Lines, Plines or Splines."
		ut01	"\nFor better results, use a closed set of curves."
		ut02	"\nEach curve can be reverted in path direction."
		ut03	"\nThe whole set can be normalized like regular airfoils between 0-1 on the x axis."
		ut04	"\nWhen normalized, the curves are recentered on the vertical axis around the rightmost point found.\n"
		)
		; Francais
		(setq
		st00    "\nLanguage utilis: "
		st00a	"\nProduction d'un fichier de format DAT  partir d'une Line, Pline ou Spline."
		st01	"\nEntrez le nom du fichier de destination (sans extension): "
		st02	"Oui Non"
		st03	"\nDsirez-vous normaliser les coordonnes (entre 0.0-1.0) ? (O/N) <O>: "
		st03a	"\n - Normalize: "
		st03b   "\nDsirez-vous inverser la direction de la courbe ? (O/N) <N>: "
		st03c	"\n - Inversion  : "
		st04    "Non"
		st04a   "Oui"
		st05	"\nEntrez le texte pour la ligne de commentaire dans le fichier: "
		st06	"\nEntrez la quantit de coordonnes que vous dsirez produire <100>:"
		st06a	"\n - Nombre de points: "
		st07	"\n\nFichier "
		st08	" sauv."
		st09	"\n- Fin -"
		st10	"\nChoisissez la courbe Line/Pline/Spline  transcrire en Dat: "
		st11	"\nNombre de points gnrs: "
		st12    "\n - L'Entit est Ferme."
		st13    "\n - L'Entit est Ouverte."
		st14	"\nDsirez-vous avoir des markers ? (O/N) <N>: "
		st14a	"\n - Marker   : "
		st20	"Ajout"
		st21	"eXit"
		st22	"Ajout eXit"
		st23	"\nAjout\\eXit <X>:"
		st24	"\n - Selection: "
		st25	"\t Normalis: "

		ut00	"\n\nCet utilitaire permet de gnrer un fichier format .DAT  partir de plusieurs Splines ou Plines bout  bout."
		ut01	"\nPour de meilleurs rsultats, utilisez une courbe ferme  l'origine."
		ut02	"\nChaque courbe peut tre inverse."
		ut03	"\nTout l'ensemble peut tre normalis entre 0-1 en x."
		ut04	"\nAvec normalisation, la courbe est recentre verticalement sur le point le plus  droite.\n"
		)
	)

	; Show active lang
	(princ st00)(prin1 lang)

	; Description
	(princ (strcat "\n" ld_version))
	(princ st00a)
	(princ (strcat "\n" ld_copyright))

	; Help info
	(princ ut00)
	(princ ut01)
	(princ ut02)
	(princ ut03)
	(princ ut04)

	; Get the dat file name; a .dat will be appended
	(setq fname (strcat (getstring st01) ext))

	; Show markers?
	(initget 0 st02) 
	(setq  Showmarker (getkword st14))
	(if (not Showmarker) (setq Showmarker st04)) ; defaults to not show markers
	(princ st14a)(princ Showmarker) 


	; while user has more curve to add and we don't hit a Closed curved.
	(setq glist nil)
	(setq todo st20)
	(while (= todo st20)

		(if (= todo st20)
			(progn
			(f_coord)

			; Add that list to the global list
			(setq glist (append glist (cdr elist)))

			)
		)

		; If curve is closed then we end.
		(if Closed 
			(setq todo st21)
			; else
			(progn
			; Get ready to ask for more
			(initget 0 st22) 
			(setq  todo (getkword st23))
			(if (not todo) (setq todo st21)) ; default to Exit
			(princ st24)(princ todo)
			)
		)

	)


	(if glist
		(progn


		; Normalize?
		(initget 0 st02) 
		(setq  donormalize (getkword st03))
		(if (not donormalize) (setq donormalize st04a)) ; default to doing a normalization
		(princ st03a)(princ donormalize)

		; Open the destination file
		(setq fp (open fname "w"))

		; Put a comment line
		(princ (strcat fname ": " 
			(getstring T st05)) fp)


		; If normalized then normalize and write results to file
		; Write the coordinates section
		(f_norm fp glist)

		; Close file pointer
		(close fp)

		; Show total nb of pts

		(princ (strcat st07 fname st08))
		; end

		(setvar "LUNITS" old_lunits)
		(setvar "LUPREC" old_luprec)
		)
	)
	
	(princ (strcat st09))
	(prin1)

)

