 LIST  C=132, N=74, E=1
 include "p16F84A.inc"

; __CONFIG _IntRC_OSC & _WDT_OFF & _CP_OFF & _MCLRE_OFF

;*******************************************************************
; Test Timer
;
;
;
;*******************************************************************
;  Variabili
;*******************************************************************
;
        ORG  0x20               ; Inizio area variabili
Count	res	1		; Generic counter
CountH	res	1		; Timer counter


;*******************************************************************
;  Descrizione bit
;*******************************************************************
;
#DEFINE	LED		PORTA,0		; output
	
#DEFINE	Page_1	STATUS,RP0  ; Page 1 bank switch

;*******************************************************************
;  Start of code
;*******************************************************************
;
	ORG	0
	goto	Init


;*******************************************************************
;  Delay
;*******************************************************************
; Per calcolare la costante di ritardo:
; Ritardo voluto = 20 mS (20.000 uS)
; Con il prescaler a 1:256 diventano 20000/256=78 conteggi del timer
; che deve essere presettato in modo che vada in overflow dopo
; 78 cicli, quindi deve essere programmato a 256-78=178 
;
;
Delay	movwf	Count
Del01	movlw	.178
		movwf	TMR0
		bcf		INTCON,T0IF
Del02	btfss	INTCON,T0IF
		goto	Del02
		decfsz	Count,f
		goto	Del01		
		return


;*******************************************************************
;  Program init
;*******************************************************************
;
Init	movlw	0x00		; xxOO OOOO Data direction 
		bsf		Page_1		; Set page 1
		movwf	TRISA		; I/O Port
    	movlw	0x07		; 0000 0111
		movwf	OPTION_REG	; Presc TMR0/256
		bcf		Page_1		; Set page 0
		clrf	PORTA		; Clear output

;*******************************************************************
;  Main program start
;*******************************************************************
;
Start	bsf		LED			; Accende LED
		movlw	.20			; 20 x 20mS = 0,4 Sec.
		call	Delay		; Tempo led spento
		bcf		LED			; Spegne LED
		movlw	.40			; 40 x 20mS = 0,8 Sec.
		call	Delay		; Tempo led spento
		goto	Start

    END
	

