; il programma si prefigge lo scopo di leggere l' ingresso proveniente dalla
; radio e di comandare il fet in accordo all' ingresso, per fare cio', all'
; accensione si conteggia il primo impulso alto (che dovrebbe essere con il 
; gas al minimo) e si prende la misura di quanto e' tmr0 , quindi ogni volta
; che l' ingresso va' alto viene prima eseguito un ciclo del tempo pari all'
; ingresso con stick a zero e poi si attende che l' ingresso vada basso, quindi
; si legge il contenuto di tmr0 e si sapra' quanto e' stato alto una volta 
; avuto il comando, si pilota il fet, per (stato alto/stick a zero)
; autore : davide ammirata,
; mail	 :davide.ammirata@tiscali.it
; sito di riferimento per informazioni su tale sw WWW.BARONEROSSO.NET


        PROCESSOR       16F84
        RADIX           DEC
        INCLUDE         "P16F84.INC"
        __CONFIG        3FF1H
		
RA0	equ	0
;*********************************DICHIARAZIONE VARIABILI**********************

		CBLOCK 0CH
conteggio
comando_motore
motore_off
attesa
calibrazione
calibrazione_tmr0
STATUS_TEMP
W_TEMP
batteria
appoggio_sottrazione
	ENDC
	
;**********************************INIZIO PROGRAMMA****************************

	ORG		00H

	goto	INIZIO
	
	ORG		04H

	goto	INTERR					;essendo le cose da fare molte, si scrivono piu' sotto


	ORG     0CH

INIZIO

	clrf	batteria				;azzera la batteria
	bsf		STATUS,RP0
	movlw 	0001111B				;SETTA LINEE RA0 RA4 INGRESSO
	movwf   TRISA & 7FH
    movlw   11110000B				;SETTA LINEE RB0 RB4 INGRESSO RB5 RB7 USCITA
    movwf   TRISB & 7FH				;quelle che useremo sono rb0 comando fet e rb4 ingresso dalla radio
	movlw   00000011B				;attiva il prescaler diviso 8
    movwf   OPTION_REG & 0x7F		; l' opzione &0x7F serve a scrivere sulla 
    								; superiore

    bcf     STATUS,RP0

	bsf 	INTCON,GIE				;attiva interrupt generale
    bsf		INTCON,RBIE				;attiva interrupt linee rb4-rb7
    clrf	comando_motore			;azzera la variabile comando_motore
	clrf	attesa					;azzera la variabile attesa
	goto	in_attesa				;passa alla routine di controllo dell' avvio

in_attesa
	btfss	attesa,0				;attende il primo ciclo alto
	goto 	in_attesa
	  						
ciclo
	movfw	calibrazione
    movwf	conteggio
    movfw	comando_motore		
    movwf	motore_off				
ciclo_motore
	movf	motore_off,F			;motore = 0 motore spento
	btfss	STATUS,Z				;se motore_off =0 salta
	bsf		PORTB,0					;se e'1 sei qui 
	btfsc	STATUS,Z				;se motore_off =1 salta
	bcf		PORTB,0					;se e' 0 sei qui
	btfss	STATUS,Z				;se motore_off=0 salta
	decf	motore_off				;se e' 1 puoi ancora decrementare
	decfsz	conteggio
	goto	ciclo_motore
	goto	ciclo
	

	

;***************************GESTIONE INTERRUPT*********************************	

INTERR
PUSH 
	MOVWF	 W_TEMP					; Copy W to TEMP register,
	SWAPF	STATUS, W				; Swap status to be saved into W
	MOVWF	STATUS_TEMP				; Save status to STATUS_TEMP register
	
	btfsc	INTCON,RBIF				;controlla flag rbif se non c'e' l' evento salta perche l' evento sara' tmr0
	goto	gestione_rbie			
	clrf	TMR0					;essendo l' evento tmr0 lo disativa e azzera, in modo da 
	bcf		INTCON,T0IE				;usarlo per misurare il comando motore
	goto	fine_int
	
gestione_rbie
	
	btfss	PORTB,4					;controlla portb,4 =1 continua su fronte_salita se =0 salta a fronte discesa.
	goto	fronte_discesa
	btfss	attesa,0				;se non e' stata fatta l' inizializzazione azzera tmr0
	clrf	TMR0					;ed esce
	btfss	attesa,0
	goto	fine_int
	

fronte_salita

	movfw	calibrazione_tmr0		;al fronte di salita carica il valore di calibrazione_tmr0
    movwf	TMR0					;in modo che all' int del tmr avremo eliminato la parte
    								;fissa del segnale di comando
    bsf		INTCON,T0IE				;e abilita l' int per tmr0
	goto	fine_int	

inizializza
	
	bsf		attesa,0				;settiamo attesa a 1 cosi' non arriveremo piu' qui
	movfw	TMR0					;copiamo il valore di tmr0 in calibrazione cosi'
	movwf	calibrazione			;stabilire quanto sara' il denominatore di  
	sublw	255						;comando_motore/calibrazione, sottraiamo da 255
	movwf	calibrazione_tmr0		;tale valore e lo mettiamo in calibrazione_motore
	goto	fine_int				;cosi' da essere utile per generare l' int di tmr0
									;ed eliminare la prima parte del comando (1ms in genere)
	
	;seconda parte, legge il valore di tmr0 e lo mette in comando_motore
fronte_discesa

	btfss	attesa,0				;controlla che non sia stata fatta l' inizializzazione
	goto	inizializza				;se non e' stata fatta la fa' ed esce
	movfw	TMR0					;se e' stata fata sposta il valore di tmr0 nell' accumulatore
									;valore che indica quanto e' il comando
	btfsc	INTCON,T0IE				;controlla se e' ancora attivo l' interrupt tmr0
	movlw	0						;se si' il fronte di discesa e' avvenuto prima di 1ms e quindi lo stick deve essere a 0
	movwf	comando_motore			;sposta W in conteggio finito
	btfss	PORTA,RA0				;controlla l' ingresso ra0, se basso, diminuisce
	call	batteria_scarica		;il comando motore
	btfsc	PORTA,RA0				;se rientra il segnale di batteria azzera la variabile
	clrf	batteria			
		 
fine_int	

POP 
	SWAPF	STATUS_TEMP,W			; Swap nibbles in STATUS_TEMP register
									; and place result into W
	MOVWF	STATUS					; Move W into STATUS register
									; (sets bank to original state)
	SWAPF	W_TEMP, F				; Swap nibbles in W_TEMP and place result in W_TEMP	
	SWAPF	W_TEMP, W				; Swap nibbles in W_TEMP and place result into W

	bcf		INTCON,T0IF				;cancella flag toif
	bcf		INTCON,RBIF				;cancella flag rbif
	
	
	RETFIE

;**********************************SUBROUTINE***********************************

batteria_scarica
	movfw	batteria				;sposta batteria in W
	sublw	15						;effettua 15-w
	btfsc	STATUS,Z				;se diverso da zero salta
									;cio' serve a non effettuare subito la riduzione
									;di potenza ma dopo un po'
	goto	controlla_motore		
	incf	batteria				
	return	
	
controlla_motore
	movlw	20
	subwf	comando_motore,W		;effettua la sottrazione comando_motore - 20
	btfsc	STATUS,Z				;se uguale a 0 va' a motore a 0
	goto	motore_a_0
	btfsc	STATUS,C				;se il risultato e' negativo vuol dire
									;che comando motore e' inferiore a 20
									;quindi inutile diminuire ulteriormente
									;(a occhio e croce siamo a meno di 1/3 stick)
	goto	decrementa_motore		;se invece il risultato e' positivo
									;comando motore e' superiore a 20 e bisogna diminuirlo
	return
	

decrementa_motore
	movlw	20
	subwf	comando_motore			;effettua la sottrazione comando_motore - 20
	return

motore_a_0
	clrf	comando_motore			;mette il motore a 0
	return
	
	END
